@extends('admin.layouts.master')

@section('extra_css')
    <link rel="stylesheet" href="/assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.css">
    <link rel="stylesheet" href="/assets/plugins/redactor/redactor.css"/>
@stop

@section('extra_js')
    <script type="text/javascript" src="/assets/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.min.js"></script>
    <script src="/assets/plugins/redactor/plugins/imagemanager.js" data-cfasync='false'></script>
    <script src="/assets/plugins/redactor/redactor.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {

            $('#tags').tagsinput();

            $('#description').redactor({
                imageUpload: '/admin/redactor',
                imageManagerJson: '/admin/redactor/images.json',
                plugins: ['imagemanager'],
                replaceDivs: false,
                convertDivs: false,
                uploadImageFields: {
                    _token: "{{csrf_token()}}"
                }
            });

            var category_el = $('#category');
            var render_type_el = $('#render_type');

            category_el.on('change', function () {
                $.ajax({
                    url: "/admin/api/get_sub_categories_by_category/" + $('#category').val(),
                    success: function (sub_categories) {

                        var $sub_category_select = $('#sub_category');
                        $sub_category_select.find('option').remove();

                        $.each(sub_categories, function (key, value) {
                            $sub_category_select.append('<option value=' + value['id'] + '>' + value['title'] + '</option>');
                        });
                    },
                    error: function (response) {
                    }
                });
            });

            render_type_el.on('change', function (ev) {
                var val = $(this).find('option:selected').val();

                console.log(val);

                if (val == "{{\App\Posts::RENDER_TYPE_TEXT}}") {
                    $('#featured_image_div').hide();
                    $('#image_parallax_div').hide();

                    $('#gallery_image_div').hide();
                    $('#video_div').hide();
                    $('#video_parallax_div').hide();
                }

                if (val == "{{\App\Posts::RENDER_TYPE_IMAGE}}") {
                    $('#featured_image_div').show();
                    $('#image_parallax_div').show();

                    $('#gallery_image_div').hide();
                    $('#video_div').hide();
                    $('#video_parallax_div').hide();
                }

                if (val == "{{\App\Posts::RENDER_TYPE_GALLERY}}") {
                    $('#gallery_image_div').show();

                    $('#featured_image_div').hide();
                    $('#image_parallax_div').hide();
                    $('#video_div').hide();
                    $('#video_parallax_div').hide();
                }

                if (val == "{{\App\Posts::RENDER_TYPE_VIDEO}}") {
                    $('#video_div').show();
                    $('#video_parallax_div').show();

                    $('#gallery_image_div').hide();
                    $('#featured_image_div').hide();
                    $('#image_parallax_div').hide();
                }

            });

            category_el.trigger('change');
            render_type_el.trigger('change');

        });
    </script>
@stop

@section('content')

    <h3 class="page-title">
        Posts
        <small>Manage Posts</small>
    </h3>

    <div class="page-bar">
        <ul class="page-breadcrumb">

            <li>
                <a href="/admin">Home</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="/admin/posts">Posts</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="/admin/posts/create">Create New Post</a>
            </li>

        </ul>
    </div>


    <!-- END PAGE HEADER-->
    <!-- BEGIN PAGE CONTENT-->
    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN PORTLET-->
            <div class="portlet box green-meadow">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-docs"></i>Create New Post
                    </div>
                    <div class="tools">
                        <a href="javascript:;" class="collapse">
                        </a>
                    </div>
                </div>

                <div class="portlet-body form">


                    <form action="/admin/posts/create" id="form-username" method="post"
                          class="form-horizontal form-bordered" enctype="multipart/form-data">

                        <div class="form-group">
                            <label class="col-sm-3 control-label"></label>

                            <div class="col-sm-4">
                                @include('admin.layouts.notify')
                            </div>
                        </div>

                        <input type="hidden" name="_token" value="{{csrf_token()}}"/>

                        <div class="form-group">
                            <label for="render_type" class="col-sm-3 control-label">Post Type</label>

                            <div class="col-sm-8">
                                <select id="render_type" class="form-control" name="render_type">
                                    <option value="{{\App\Posts::RENDER_TYPE_TEXT}}">Text</option>
                                    <option value="{{\App\Posts::RENDER_TYPE_IMAGE}}">Image</option>
                                    <option value="{{\App\Posts::RENDER_TYPE_GALLERY}}">Gallery</option>
                                    <option value="{{\App\Posts::RENDER_TYPE_VIDEO}}">Video</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="title" class="col-sm-3 control-label">Title</label>

                            <div class="col-sm-8">
                                <input id="title" class="form-control" type="text" name="title"
                                       placeholder="Enter Post Title" value="{{old('title')}}"/>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="category" class="col-sm-3 control-label">Category</label>

                            <div class="col-sm-8">
                                <select id="category" name="category" class="form-control">
                                    @foreach($categories as $category)
                                        <option value="{{$category->id}}">{{$category->title}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="sub_category" class="col-sm-3 control-label">Sub Category</label>

                            <div class="col-sm-8">
                                <select id="sub_category" name="sub_category" class="form-control">

                                </select>
                            </div>
                        </div>

                        <div class="form-group" id="featured_image_div">
                            <label for="featured_image" class="col-sm-3 control-label">Featured Image</label>

                            <div class="col-sm-8">
                                <input id="featured_image" class="form-control" type="file" name="featured_image"/>
                            </div>
                        </div>

                        <div class="form-group" id="gallery_image_div">
                            <label for="image_gallery" class="col-sm-3 control-label">Image Gallery</label>

                            <div class="col-sm-8">
                                <input id="image_gallery" class="form-control" type="file" name="image_gallery[]"
                                       multiple/>
                            </div>
                        </div>

                        <div class="form-group" id="video_div">
                            <label for="video_embed_code" class="col-sm-3 control-label">Video Embed Code</label>

                            <div class="col-sm-8">
                                <textarea id="video_embed_code" class="form-control" name="video_embed_code"></textarea>
                            </div>
                        </div>

                        <div class="form-group" id="image_parallax_div">

                            <div class="col-md-offset-3 col-md-8">
                                <div class="checkbox">
                                    <label>
                                        <input name="image_parallax" type="checkbox"> Make Featured Image Parallax
                                    </label>
                                </div>
                            </div>

                        </div>

                        <div class="form-group" id="video_parallax_div">

                            <div class="col-md-offset-3 col-md-8">
                                <div class="checkbox">
                                    <label>
                                        <input name="video_parallax" type="checkbox"> Make Video Parallax </label>
                                </div>
                            </div>

                        </div>

                        <div class="form-group">
                            <label for="description" class="col-sm-3 control-label">Description</label>

                            <div class="col-sm-8">
                                <textarea id="description" class="form-control" name="description"></textarea>
                            </div>
                        </div>

                        <div class="form-group">

                            <label for="tags" class="col-sm-3 control-label">Select Tags</label>

                            <div class="col-sm-8">
                                <input type="text" id="tags" name="tags" multiple/>
                            </div>

                        </div>

                        <div class="form-group">

                            <div class="col-md-offset-3 col-md-8">
                                <div class="checkbox">
                                    <label>
                                        <input name="featured" type="checkbox"> Featured </label>
                                </div>
                            </div>

                        </div>

                        <div class="form-group">
                            <label for="rating_box" class="col-sm-3 control-label">Rating Box</label>

                            <div class="col-sm-8">
                                <select id="rating_box" class="form-control" name="rating_box">
                                    <option value="0">No Rating Box</option>
                                    <option value="1">Add 5 Start Rating Box</option>
                                </select>
                            </div>
                        </div>


                        <div class="form-group">

                            <div class="col-md-offset-3 col-md-8">
                                <div class="checkbox">
                                    <label>
                                        <input name="show_in_mega_menu" type="checkbox"> Show in Mega Menu </label>
                                </div>
                            </div>

                        </div>

                        <div class="form-group">

                            <div class="col-md-offset-3 col-md-8">
                                <div class="checkbox">
                                    <label>
                                        <input name="show_featured_image_in_post" type="checkbox"> Show Featured Image Above Post Description </label>
                                </div>
                            </div>

                        </div>

                        <div class="form-group">

                            <div class="col-md-offset-3 col-md-8">
                                <div class="checkbox">
                                    <label>
                                        <input name="show_author_box" checked type="checkbox"> Show Author Box </label>
                                </div>
                            </div>

                        </div>

                        <div class="form-group">

                            <div class="col-md-offset-3 col-md-8">
                                <div class="checkbox">
                                    <label>
                                        <input name="show_author_socials" checked type="checkbox"> Show Author Social Links </label>
                                </div>
                            </div>

                        </div>

                        <div class="form-group">
                            <label for="author" class="col-sm-3 control-label">Posted By</label>

                            <div class="col-sm-8">
                                <select id="author" class="form-control" name="author">
                                    @foreach($admins as $admin)
                                        <option value="{{$admin->id}}"
                                                class="label label-info">{{$admin->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                        </div>

                        <div class="form-group">
                            <label for="status" class="col-sm-3 control-label">Status</label>

                            <div class="col-sm-8">
                                <select id="status" class="form-control" name="status">
                                    <option value="{{\App\Posts::STATUS_PUBLISHED}}">Published</option>
                                    <option value="{{\App\Posts::STATUS_HIDDEN}}">Hidden</option>
                                </select>
                            </div>
                        </div>


                        <div class="form-actions">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    <button type="submit" class="btn purple"><i class="fa fa-check"></i> Save</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!-- END PORTLET-->
        </div>
    </div>
@stop